import Utilities.waveform_creator as wc
import Utilities.nidaq_operations as no
import time

channel_name = 'Dev1/ao0'
task = no.create_ao_task(channel_name)
    
num, samp_freq = 500, 5000
a, f, shape = 5., 50., 'Sine'

t = wc.create_time_data(num, samp_freq)
y = wc.create_waveform_data(t, a, f, shape)

no.config_daq_timing(task, num, 'Continuous', samp_freq)

task.write(y, auto_start=True)

time.sleep(10.)

task.stop()

task.close()
